/*
 * Decompiled with CFR 0.152.
 */
package com.pannous.desktopctrl.client;

import com.pannous.desktopctrl.client.Command;
import com.pannous.desktopctrl.client.Helper;
import com.pannous.desktopctrl.client.JavaCommand;
import com.pannous.desktopctrl.client.KeyCommand;
import com.pannous.desktopctrl.client.Keyboard;
import com.pannous.desktopctrl.client.MouseCommand;
import com.pannous.desktopctrl.client.NativeCommand;
import com.pannous.desktopctrl.client.StringCommand;
import java.awt.Robot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.KeyStroke;

public class Engine {
    private Logger logger = Logger.getLogger("Engine");
    private boolean enableNative = false;
    private Robot robot;
    private Keyboard keyboard;

    public static void main(String[] args) throws Exception {
        Robot r = new Robot();
        Keyboard keyboard = new Keyboard(r);
        new Engine(r, keyboard).execute("alt TAB");
    }

    public Engine(Robot robot, Keyboard keyboard) {
        this.robot = robot;
        this.keyboard = keyboard;
    }

    public Engine setNative(boolean enable) {
        this.enableNative = enable;
        return this;
    }

    public List<Command> createCommands(String commandStr) {
        ArrayList<Command> commands = new ArrayList<Command>();
        LinkedHashMap<Integer, KeyCommand> todoRelease = new LinkedHashMap<Integer, KeyCommand>();
        for (String command : commandStr.split("\\,")) {
            String lower = (command = command.trim()).toLowerCase();
            if (lower.startsWith("native:")) {
                if (!this.enableNative) continue;
                commands.add(new NativeCommand(command.substring(7)));
                continue;
            }
            if (lower.startsWith("java:")) {
                commands.add(new JavaCommand(command.substring(5)));
                continue;
            }
            if (lower.contains("mouse")) {
                String tmp = command.replace("mouse", " ").trim();
                String stepInfo = "normal";
                if (tmp.contains("big")) {
                    stepInfo = "big";
                } else if (tmp.contains("small")) {
                    stepInfo = "small";
                }
                commands.add(new MouseCommand(this.robot, tmp, stepInfo));
                continue;
            }
            KeyCommand keycommand = this.addCommand(commands, command);
            if (keycommand == null) continue;
            this.handleStroke(todoRelease, keycommand);
        }
        if (!todoRelease.isEmpty()) {
            this.releaseAll(commands, todoRelease.values());
        }
        return commands;
    }

    private void handleStroke(Map<Integer, KeyCommand> todoRelease, KeyCommand keycommand) {
        if (keycommand.isPress() && !keycommand.isRelease()) {
            todoRelease.put(keycommand.getKeycode(), keycommand);
        }
        if (keycommand.isRelease()) {
            todoRelease.remove(keycommand.getKeycode());
        }
    }

    public void releaseAll(Collection<Command> keyCommands, Collection<KeyCommand> todoRelease) {
        if (!todoRelease.isEmpty()) {
            ArrayList<KeyCommand> tmpList = new ArrayList<KeyCommand>();
            for (KeyCommand pressedKC : todoRelease) {
                tmpList.add(new KeyCommand(this.robot, pressedKC.getStroke(), pressedKC.getKeycode(), false, true));
            }
            Collections.reverse(tmpList);
            keyCommands.addAll(tmpList);
        }
    }

    private int handleMeta(String stroke) {
        int keycode = 0;
        String tmpStroke = stroke.toLowerCase();
        if (tmpStroke.contains("alt")) {
            keycode |= 0x12;
        }
        if (tmpStroke.contains("altgraph")) {
            keycode |= 0xFF7E;
        }
        if (tmpStroke.contains("shift")) {
            keycode |= 0x10;
        }
        if (tmpStroke.contains("meta")) {
            keycode |= 0x9D;
        }
        if (tmpStroke.contains("ctrl") || tmpStroke.contains("control")) {
            keycode |= 0x11;
        }
        return keycode;
    }

    public void execute(String stroke) {
        List<Command> commands = this.createCommands(stroke);
        this.logger.info("EXECUTE: " + commands);
        for (Command command : commands) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                break;
            }
            command.doAction();
        }
    }

    private KeyCommand embedMeta(Collection commands, String meta, int metaKeycode, String stroke) {
        KeyCommand metaKeyCommand = new KeyCommand(this.robot, meta, metaKeycode, true, false);
        commands.add(metaKeyCommand);
        KeyCommand mainCommand = this.addCommand(commands, stroke);
        metaKeyCommand = new KeyCommand(this.robot, meta, metaKeycode, false, true);
        commands.add(metaKeyCommand);
        return mainCommand;
    }

    private KeyCommand addCommand(Collection commands, String command) {
        int keycode;
        int metaKeycode;
        String stroke;
        String[] subStrokes;
        boolean release;
        String lower = command.toLowerCase();
        boolean press = lower.contains("press") || lower.contains("type");
        boolean bl = release = lower.contains("release") || lower.contains("type");
        if (!press && !release) {
            press = true;
            release = true;
        }
        if ((subStrokes = (stroke = Helper.innerTrim(command.replaceAll("type", " ").replaceAll("press", " ").replaceAll("release", " ").replaceAll("CONTROL", "ctrl").replaceAll("control", "ctrl"))).split(" ", 2)).length > 1 && (metaKeycode = this.handleMeta(subStrokes[0])) != 0) {
            return this.embedMeta(commands, subStrokes[0], metaKeycode, subStrokes[1]);
        }
        if (stroke.length() == 1) {
            char c = stroke.charAt(0);
            if (Character.isUpperCase(c) || c == '?') {
                c = Character.toLowerCase(c);
                return this.embedMeta(commands, "shift", 16, "" + c);
            }
            keycode = Keyboard.getKeyCode(c);
        } else {
            KeyStroke ks = KeyStroke.getKeyStroke(stroke);
            keycode = ks == null ? this.handleMeta(stroke) : ks.getKeyCode();
        }
        if (keycode != 0) {
            KeyCommand keycommand = new KeyCommand(this.robot, stroke, keycode, press, release);
            commands.add(keycommand);
            return keycommand;
        }
        StringCommand cmd = new StringCommand(this.keyboard, stroke);
        commands.add(cmd);
        return null;
    }
}

